/*
 *
 *  Copyright (C) 2010-2011 Amr Thabet <amr.thabet@student.alx.edu.eg>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to Amr Thabet 
 *  amr.thabet@student.alx.edu.eg
 *
 */
#include "../x86emu.h"
int Debugger::AddBp(string s){
    bp[nbp].ptr=parser(s); 
    bp[nbp].state=BP_RUN;
    string str;
    dword n=bp[nbp].ptr;
    for (int i=0;i<24;i++){
        ins_disasm* ins=process->getsystem()->disasm((ins_disasm*)malloc(sizeof(ins_disasm)),(char*)n,str);
        n+=ins->hde.len;
        //cout << str <<"\n";
    };
    nbp++;
};  
string Debugger::GetLastError(){
       return lasterror;       
};
bool Debugger::TestBp(int num,Thread& thread,ins_disasm* ins){
    if (num>=nbp)return false;        //outside the limits
    int b=call_to_func(bp[num].ptr,(dword)&thread,(dword)ins);
    if (b!=0)return true;
    return false;
};
bool Debugger::TestBp(Thread& thread,ins_disasm* ins){
     bool b=false;
    for (int n=0;n<nbp;n++){
        int i=n;
        if (bp[i].state==BP_RUN){
            b=TestBp(i,thread,ins); 
        };
        if (b==true){goto YES;}
    };
    return false;
YES:
    return true;
};
Debugger::Debugger(Process& c){
   process=&c;
   func_entries=0;
   init_funcs();
   nbp=0;
   lasterror="";
};
int call_to_func(dword mem,dword a,dword c){
    int b=0;
    //cout << a << "\n";
    asm (   "call %%eax;"
            :"=a"(b)        /* output */
            :"a"(mem),"b"(a),"d"(c)      /* input */
            );
           // cout << n << "\n";
    return b;
};
void Debugger::RemoveBp(int index){
     if (index<nbp){
        bp[index].state=BP_REMOVE;
        free((dword*)bp[index].ptr);            
     
     };
};
void Debugger::PauseBp(int index){
     if (index<nbp){
        bp[index].state=BP_PAUSE;          
     };
};
void Debugger::ActivateBp(int index){
     if (index<nbp){
        if(bp[index].state!=BP_REMOVE)bp[index].state=BP_RUN;          
     };
};
